package gov.va.med.mhv.usermgmt.service;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.exception.MHVException;

@Path("/accountUpgrade")
@Service
public interface TwoFactorAuthenticationService {

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/sendCode/{userProfileId}")
	public void sendCode(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/verifyCode/{userProfileId}/{code}")
	public void verifyCode(@PathParam("userProfileId") Long userProfileId, @PathParam("code") String code) throws MHVException;
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/codeSent/{userProfileId}")
	public Boolean codeSent(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/makePremium/{userProfileId}/{dsLogonUser}")
	public void makePremium(@PathParam("userProfileId") Long userProfileId, @PathParam("dsLogonUser") Boolean dsLogonUser) throws MHVException;
}
